/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.bedrock;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import org.joml.Vector3f;

public class BedrockGeometry {
    public Description description;
    public List<Bone> bones;

    public static class Vector3fDeserializer
    implements JsonDeserializer<Vector3f> {
        public Vector3f deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array = json.getAsJsonArray();
            return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
        }
    }

    public static class CubeDeserializer
    implements JsonDeserializer<Cube> {
        public Cube deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            Vector3f origin = (Vector3f)context.deserialize(object.get("origin"), Vector3f.class);
            Vector3f size = (Vector3f)context.deserialize(object.get("size"), Vector3f.class);
            boolean mirror = object.has("mirror") && object.get("mirror").getAsBoolean();
            Vector3f pivot = null;
            if (object.has("pivot")) {
                pivot = (Vector3f)context.deserialize(object.get("pivot"), Vector3f.class);
            }
            Vector3f rotation = null;
            if (object.has("rotation")) {
                rotation = (Vector3f)context.deserialize(object.get("rotation"), Vector3f.class);
            }
            JsonElement uvJson = object.get("uv");
            HashMap<class_2350, float[]> uvs = new HashMap<class_2350, float[]>();
            if (uvJson.isJsonArray()) {
                JsonArray uvArray = uvJson.getAsJsonArray();
                float uv0 = uvArray.get(0).getAsFloat();
                float uv1 = uvArray.get(1).getAsFloat();
                uvs.put(class_2350.field_11036, new float[]{uv0 + size.z, uv1, uv0 + size.z + size.x, uv1 + size.z});
                uvs.put(class_2350.field_11033, new float[]{uv0 + size.z + size.x, uv1 + size.z, uv0 + size.z + size.x * 2.0f, uv1});
                uvs.put(class_2350.field_11034, new float[]{uv0 + size.z + size.x, uv1 + size.z, uv0 + size.z * 2.0f + size.x, uv1 + size.z + size.y});
                uvs.put(class_2350.field_11043, new float[]{uv0 + size.z * 2.0f + size.x, uv1 + size.z, uv0 + size.z * 2.0f + size.x * 2.0f, uv1 + size.z + size.y});
                uvs.put(class_2350.field_11039, new float[]{uv0, uv1 + size.z, uv0 + size.z, uv1 + size.z + size.y});
                uvs.put(class_2350.field_11035, new float[]{uv0 + size.z, uv1 + size.z, uv0 + size.z + size.x, uv1 + size.z + size.y});
                if (mirror) {
                    float[] up = (float[])uvs.get(class_2350.field_11036);
                    float temp = up[0];
                    up[0] = up[2];
                    up[2] = temp;
                    float[] down = (float[])uvs.get(class_2350.field_11033);
                    temp = down[0];
                    down[0] = down[2];
                    down[2] = temp;
                    float[] north = (float[])uvs.get(class_2350.field_11043);
                    temp = north[0];
                    north[0] = north[2];
                    north[2] = temp;
                    float[] south = (float[])uvs.get(class_2350.field_11035);
                    temp = south[0];
                    south[0] = south[2];
                    south[2] = temp;
                    float[] east = (float[])uvs.remove(class_2350.field_11034);
                    temp = east[0];
                    east[0] = east[2];
                    east[2] = temp;
                    float[] west = (float[])uvs.remove(class_2350.field_11039);
                    temp = west[0];
                    west[0] = west[2];
                    west[2] = temp;
                    uvs.put(class_2350.field_11034, west);
                    uvs.put(class_2350.field_11039, east);
                }
            } else if (uvJson.isJsonObject()) {
                for (Map.Entry entry : uvJson.getAsJsonObject().entrySet()) {
                    class_2350 direction = class_2350.method_10168((String)((String)entry.getKey()));
                    if (direction == null) continue;
                    JsonObject faceUv = ((JsonElement)entry.getValue()).getAsJsonObject();
                    JsonArray uvOrigin = faceUv.getAsJsonArray("uv");
                    JsonArray uvSize = faceUv.getAsJsonArray("uv_size");
                    uvs.put(direction, new float[]{uvOrigin.get(0).getAsFloat(), uvOrigin.get(1).getAsFloat(), uvOrigin.get(0).getAsFloat() + uvSize.get(0).getAsFloat(), uvOrigin.get(1).getAsFloat() + uvSize.get(1).getAsFloat()});
                }
            } else {
                throw new RuntimeException("Unknown UV representation: " + String.valueOf(json));
            }
            Cube cube = new Cube();
            cube.origin = origin;
            cube.size = size;
            cube.pivot = pivot;
            cube.rotation = rotation;
            cube.uvs = uvs;
            cube.mirror = mirror;
            return cube;
        }
    }

    public static class Cube {
        public Vector3f origin;
        public Vector3f size;
        public Vector3f pivot;
        public Vector3f rotation;
        public Map<class_2350, float[]> uvs;
        public boolean mirror;
    }

    public static class Bone {
        public String name;
        public String parent;
        public Vector3f pivot;
        public Vector3f rotation;
        public List<Cube> cubes;
    }

    public static class Description {
        public String identifier;
        @SerializedName(value="texture_width")
        public int textureWidth;
        @SerializedName(value="texture_height")
        public int textureHeight;
    }
}

